DROP PROCEDURE [hips].[EpisodeDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: Friday, 22 June 2012 4:31 PM
-- Description:   Deletes an existing record from the Episode Table
-- =============================================
CREATE PROCEDURE [hips].[EpisodeDelete]
(
@EpisodeId INT
)
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @intErrorCode INT,
			@intRowsAffected INT
	SELECT  @intErrorCode = 0,
			@intRowsAffected = 0
	DELETE
		[hips].[Episode]
	WHERE [EpisodeId] = @EpisodeId
	
	SELECT  @intErrorCode = @@ERROR,
			@intRowsAffected = @@ROWCOUNT

	SELECT @intRowsAffected AS RowsAffected
	RETURN(@intErrorCode)
END
GO

